/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.Painter;
import com.sun.lwuit.Popup;
import com.sun.lwuit.RunnableWrapper;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.CommonTransitions;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.layouts.FlowLayout;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;
import java.util.Vector;

public class Form
extends Container {
    private Painter glassPane;
    private Container contentPane = new Container(new FlowLayout());
    private Label title = new Label("", "Title");
    private MenuBar menuBar = new MenuBar();
    private Popup current;
    private Command selectCommand;
    private Command defaultCommand;
    private Component dragged;
    private Command backCommand;
    private Command clearCommand;
    private Vector animatableComponents;
    static int leftSK = -6;
    static int rightSK = -7;
    static int rightSK2 = -7;
    static int backSK = -11;
    static int clearSK = -8;
    static int backspaceSK = -8;
    private Component lastFocused;
    private Component focused;
    private Component focusCycleRoot;
    private Vector mediaComponents;
    private Transition transitionInAnimator;
    private Transition transitionOutAnimator;
    private ActionListener commandListener;
    private Form previousForm;
    private boolean tint;
    private int tintColor;
    private Vector focusDownSequence;
    private Vector focusRightSequence;
    private Hashtable keyListeners;
    private Hashtable gameKeyListeners;
    private boolean cyclicFocus = true;

    public Form() {
        super(new BorderLayout());
        this.setVisible(false);
        Style formStyle = this.getStyle();
        int w = Display.getInstance().getDisplayWidth() - (formStyle.getMargin(1) + formStyle.getMargin(3));
        int h = Display.getInstance().getDisplayHeight() - (formStyle.getMargin(0) + formStyle.getMargin(2));
        this.setWidth(w);
        this.setHeight(h);
        this.setPreferredSize(new Dimension(w, h));
        super.addComponent("North", (Component)this.title);
        super.addComponent("Center", (Component)this.contentPane);
        super.addComponent("South", (Component)this.menuBar);
        this.contentPane.setScrollableY(true);
        this.focusCycleRoot = this.contentPane;
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.initLaf(laf);
        this.tintColor = laf.getDefaultFormTintColor();
        formStyle.setBgTransparency(255);
    }

    public void setMenuStyle(Style s) {
        this.menuBar.setStyle(s);
    }

    public void setSoftButtonStyle(Style s) {
        this.menuBar.setStyle(s);
    }

    public Style getSoftButtonStyle() {
        return this.menuBar.getStyle();
    }

    protected void hideNotify() {
    }

    protected void showNotify() {
    }

    protected void sizeChanged(int w, int h) {
        this.setSize(new Dimension(w, h));
        this.setShouldCalcPreferredSize(true);
        this.doLayout();
        this.repaint();
    }

    public void setGlassPane(Painter glassPane) {
        this.glassPane = glassPane;
        this.repaint();
    }

    public Painter getGlassPane() {
        return this.glassPane;
    }

    public void setTitleStyle(Style s) {
        this.title.setStyle(s);
    }

    public Label getTitleComponent() {
        return this.title;
    }

    public void addKeyListener(int keyCode, ActionListener listener) {
        if (this.keyListeners == null) {
            this.keyListeners = new Hashtable();
        }
        this.addKeyListener(keyCode, listener, this.keyListeners);
    }

    public void removeKeyListener(int keyCode, ActionListener listener) {
        if (this.keyListeners == null) {
            return;
        }
        this.removeKeyListener(keyCode, listener, this.keyListeners);
    }

    public void removeGameKeyListener(int keyCode, ActionListener listener) {
        if (this.gameKeyListeners == null) {
            return;
        }
        this.removeKeyListener(keyCode, listener, this.gameKeyListeners);
    }

    private void addKeyListener(int keyCode, ActionListener listener, Hashtable keyListeners) {
        Integer code;
        Vector<ActionListener> vec;
        if (keyListeners == null) {
            keyListeners = new Hashtable();
        }
        if ((vec = (Vector<ActionListener>)keyListeners.get(code = new Integer(keyCode))) == null) {
            vec = new Vector<ActionListener>();
            vec.addElement(listener);
            keyListeners.put(code, vec);
            return;
        }
        if (!vec.contains(listener)) {
            vec.addElement(listener);
        }
    }

    private void removeKeyListener(int keyCode, ActionListener listener, Hashtable keyListeners) {
        if (keyListeners == null) {
            return;
        }
        Integer code = new Integer(keyCode);
        Vector vec = (Vector)keyListeners.get(code);
        if (vec == null) {
            return;
        }
        vec.removeElement(listener);
        if (vec.size() == 0) {
            keyListeners.remove(code);
        }
    }

    public void addGameKeyListener(int keyCode, ActionListener listener) {
        if (this.gameKeyListeners == null) {
            this.gameKeyListeners = new Hashtable();
        }
        this.addKeyListener(keyCode, listener, this.gameKeyListeners);
    }

    public int getSoftButtonCount() {
        return this.menuBar.getSoftButtons().length;
    }

    public Button getSoftButton(int offset) {
        return this.menuBar.getSoftButtons()[offset];
    }

    public Style getMenuStyle() {
        return this.menuBar.getMenuStyle();
    }

    public Style getTitleStyle() {
        return this.title.getStyle();
    }

    Form getPreviousForm() {
        return this.previousForm;
    }

    void initLaf(LookAndFeel laf) {
        this.transitionOutAnimator = laf.getDefaultFormTransitionOut();
        this.transitionInAnimator = laf.getDefaultFormTransitionIn();
    }

    void clearFocusVectors() {
        this.focusDownSequence = null;
        this.focusRightSequence = null;
    }

    void setDraggedComponent(Component dragged) {
        this.dragged = dragged;
    }

    synchronized void initFocusRight() {
        if (this.focusRightSequence == null) {
            this.focusRightSequence = new Vector();
            this.findAllFocusable(this.contentPane, this.focusRightSequence, true);
        }
    }

    synchronized void initFocusDown() {
        if (this.focusDownSequence == null) {
            this.focusDownSequence = new Vector();
            this.findAllFocusable(this.contentPane, this.focusDownSequence, false);
        }
    }

    private void addSortedComponentRight(Vector components, Component c) {
        int componentCount = components.size();
        int componentX = c.getAbsoluteX();
        int bestSpot = 0;
        Component scrollableParent = this.findScrollableAncestor(c);
        for (int iter = 0; iter < componentCount; ++iter) {
            Component current = (Component)components.elementAt(iter);
            Component currentScrollParent = this.findScrollableAncestor(current);
            if (currentScrollParent == scrollableParent) {
                if (this.isInSameRow(current, c)) {
                    int currentX = current.getAbsoluteX();
                    if (currentX > componentX) continue;
                    bestSpot = iter + 1;
                    continue;
                }
            } else {
                Component tempScrollableParent = scrollableParent;
                if (scrollableParent == null) {
                    tempScrollableParent = c;
                }
                Component tempCurrentScrollParent = currentScrollParent;
                if (currentScrollParent == null) {
                    tempCurrentScrollParent = current;
                }
                if (tempCurrentScrollParent.getAbsoluteX() > tempScrollableParent.getAbsoluteX()) continue;
                if (this.isInSameRow(tempCurrentScrollParent, tempScrollableParent)) {
                    bestSpot = iter + 1;
                    continue;
                }
            }
            if (current.getAbsoluteY() >= c.getAbsoluteY()) continue;
            bestSpot = iter + 1;
        }
        components.insertElementAt(c, bestSpot);
    }

    private Component findScrollableAncestor(Component c) {
        if ((c = c.getParent()) == null || c.isScrollable()) {
            return c;
        }
        return this.findScrollableAncestor(c);
    }

    private void addSortedComponentDown(Vector components, Component c) {
        int componentCount = components.size();
        int componentY = c.getAbsoluteY();
        int bestSpot = 0;
        Component scrollableParent = this.findScrollableAncestor(c);
        for (int iter = 0; iter < componentCount; ++iter) {
            Component current = (Component)components.elementAt(iter);
            Component currentScrollParent = this.findScrollableAncestor(current);
            if (currentScrollParent == scrollableParent) {
                if (this.isInSameColumn(current, c)) {
                    int currentY = current.getAbsoluteY();
                    if (currentY > componentY) continue;
                    bestSpot = iter + 1;
                    continue;
                }
            } else {
                Component tempScrollableParent = scrollableParent;
                if (scrollableParent == null) {
                    tempScrollableParent = c;
                }
                Component tempCurrentScrollParent = currentScrollParent;
                if (currentScrollParent == null) {
                    tempCurrentScrollParent = current;
                }
                if (tempCurrentScrollParent.getAbsoluteY() > tempScrollableParent.getAbsoluteY()) continue;
                if (this.isInSameColumn(tempCurrentScrollParent, tempScrollableParent)) {
                    bestSpot = iter + 1;
                    continue;
                }
            }
            if (current.getAbsoluteX() >= c.getAbsoluteX()) continue;
            bestSpot = iter + 1;
        }
        components.insertElementAt(c, bestSpot);
    }

    private boolean isInSameColumn(Component source, Component dest) {
        return Rectangle.intersects(source.getAbsoluteX(), source.getAbsoluteY(), source.getWidth(), Integer.MAX_VALUE, dest.getAbsoluteX(), dest.getAbsoluteY(), dest.getWidth(), dest.getHeight());
    }

    private boolean isInSameRow(Component source, Component dest) {
        return Rectangle.intersects(source.getAbsoluteX(), source.getAbsoluteY(), Integer.MAX_VALUE, source.getHeight(), dest.getAbsoluteX(), dest.getAbsoluteY(), dest.getWidth(), dest.getHeight());
    }

    private void addSortedComponent(Vector components, Component c, boolean toTheRight) {
        if (toTheRight) {
            this.addSortedComponentRight(components, c);
        } else {
            this.addSortedComponentDown(components, c);
        }
    }

    public void setDefaultCommand(Command defaultCommand) {
        this.defaultCommand = defaultCommand;
    }

    public Command getDefaultCommand() {
        if (this.selectCommand != null) {
            return this.selectCommand;
        }
        return this.defaultCommand;
    }

    public void setClearCommand(Command clearCommand) {
        this.clearCommand = clearCommand;
    }

    public Command getClearCommand() {
        return this.clearCommand;
    }

    public void setBackCommand(Command backCommand) {
        this.backCommand = backCommand;
    }

    public Command getBackCommand() {
        return this.backCommand;
    }

    private void findAllFocusable(Container c, Vector v, boolean toTheRight) {
        int size = c.getComponentCount();
        for (int iter = 0; iter < size; ++iter) {
            Component current = c.getComponentAt(iter);
            if (current instanceof Container) {
                this.findAllFocusable((Container)current, v, toTheRight);
            }
            if (!current.isFocusable()) continue;
            this.addSortedComponent(v, current, toTheRight);
        }
    }

    public Form(String title) {
        this();
        this.title.setText(title);
    }

    protected String getUIID() {
        return "Form";
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void removeAll() {
        this.contentPane.removeAll();
    }

    public void setBgImage(Image bgImage) {
        this.getStyle().setBgImage(bgImage);
    }

    public void setLayout(Layout layout) {
        this.contentPane.setLayout(layout);
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void addComponent(Component cmp) {
        this.contentPane.addComponent(cmp);
        this.setShouldCalcPreferredSize(true);
    }

    public void addComponent(Object constraints, Component cmp) {
        this.contentPane.addComponent(constraints, cmp);
        this.setShouldCalcPreferredSize(true);
    }

    public void addComponent(int index, Object constraints, Component cmp) {
        this.contentPane.addComponent(index, constraints, cmp);
        this.setShouldCalcPreferredSize(true);
    }

    public void addComponent(int index, Component cmp) {
        this.contentPane.addComponent(index, cmp);
    }

    public void replace(Component current, Component next, Transition t) {
        this.contentPane.replace(current, next, t);
        this.setShouldCalcPreferredSize(true);
    }

    public void replaceAndWait(Component current, Component next, Transition t) {
        this.contentPane.replaceAndWait(current, next, t);
        this.setShouldCalcPreferredSize(true);
    }

    public void removeComponent(Component cmp) {
        this.contentPane.removeComponent(cmp);
        this.setShouldCalcPreferredSize(true);
    }

    void registerMediaComponent(Component mediaCmp) {
        if (this.mediaComponents == null) {
            this.mediaComponents = new Vector();
        }
        if (!this.mediaComponents.contains(mediaCmp)) {
            this.mediaComponents.addElement(mediaCmp);
        }
    }

    public final boolean hasMedia() {
        return this.mediaComponents != null && this.mediaComponents.size() > 0;
    }

    void deregisterMediaComponent(Component mediaCmp) {
        this.mediaComponents.removeElement(mediaCmp);
    }

    public void registerAnimated(Animation cmp) {
        if (this.animatableComponents == null) {
            this.animatableComponents = new Vector();
        }
        if (!this.animatableComponents.contains(cmp)) {
            this.animatableComponents.addElement(cmp);
        }
    }

    public void deregisterAnimated(Animation cmp) {
        if (this.animatableComponents != null) {
            this.animatableComponents.removeElement(cmp);
        }
    }

    int getFocusPosition(Component c) {
        this.initFocusDown();
        return this.focusDownSequence.indexOf(c);
    }

    void repaintAnimations() {
        if (this.animatableComponents != null && this.isVisible()) {
            for (int iter = 0; iter < this.animatableComponents.size(); ++iter) {
                Animation c = (Animation)this.animatableComponents.elementAt(iter);
                if (!c.animate()) continue;
                if (c instanceof Component) {
                    Rectangle rect = ((Component)c).getDirtyRegion();
                    if (rect != null) {
                        ((Component)c).repaint(rect.getX(), rect.getY(), rect.getSize().getWidth(), rect.getSize().getHeight());
                        continue;
                    }
                    ((Component)c).repaint();
                    continue;
                }
                Display.getInstance().repaint(c);
            }
        }
    }

    boolean hasAnimations() {
        return this.animatableComponents != null && this.animatableComponents.size() > 0;
    }

    public void refreshTheme() {
        if (this.menuBar != null && this.menuBar.getParent() == null) {
            this.menuBar.refreshTheme();
        }
        if (this.title != null && this.title.getParent() == null) {
            this.title.refreshTheme();
        }
        super.refreshTheme();
    }

    public void paintBackground(Graphics g) {
        super.paintBackground(g);
    }

    public Transition getTransitionInAnimator() {
        return this.transitionInAnimator;
    }

    public void setTransitionInAnimator(Transition transitionInAnimator) {
        this.transitionInAnimator = transitionInAnimator;
    }

    public Transition getTransitionOutAnimator() {
        return this.transitionOutAnimator;
    }

    public void setTransitionOutAnimator(Transition transitionOutAnimator) {
        this.transitionOutAnimator = transitionOutAnimator;
    }

    public void setCommandListener(ActionListener commandListener) {
        this.commandListener = commandListener;
    }

    protected void actionCommand(Command cmd) {
    }

    private void actionCommandImpl(Command cmd) {
        if (cmd == null) {
            return;
        }
        if (cmd != this.selectCommand) {
            if (this.commandListener != null) {
                this.commandListener.actionPerformed(new ActionEvent(cmd));
            }
            this.actionCommand(cmd);
        } else {
            Component c = this.getFocused();
            if (c != null) {
                c.fireClicked();
            }
        }
    }

    void initFocused() {
        if (this.focused == null) {
            this.layoutContainer();
            this.initFocusDown();
            if (this.focusDownSequence.size() > 0) {
                this.setFocused((Component)this.focusDownSequence.elementAt(0));
            }
        }
    }

    public void show() {
        if (this.transitionOutAnimator == null && this.transitionInAnimator == null) {
            this.initLaf(UIManager.getInstance().getLookAndFeel());
        }
        this.initFocused();
        this.onShow();
        Display.getInstance().setCurrent(this);
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        if (this.contentPane != null) {
            this.contentPane.setSmoothScrolling(smoothScrolling);
        }
    }

    public boolean isSmoothScrolling() {
        return this.contentPane.isSmoothScrolling();
    }

    public int getScrollAnimationSpeed() {
        return this.contentPane.getScrollAnimationSpeed();
    }

    public void setScrollAnimationSpeed(int animationSpeed) {
        this.contentPane.setScrollAnimationSpeed(animationSpeed);
    }

    protected void onShow() {
    }

    void showModal(int top, int bottom, int left, int right, boolean includeTitle, boolean modal) {
        Display.getInstance().flushEdt();
        if (this.previousForm == null) {
            this.previousForm = Display.getInstance().getCurrent();
            if (this.previousForm == null) {
                this.previousForm = new Form();
                this.previousForm.show();
            }
            this.previousForm.tint = true;
        }
        Painter p = this.getStyle().getBgPainter();
        if (top > 0 || bottom > 0 || left > 0 || right > 0) {
            if (includeTitle) {
                this.title.getStyle().setMargin(top, 0, left, right);
                this.contentPane.getStyle().setMargin(0, bottom, left, right);
            } else {
                this.contentPane.getStyle().setMargin(top, bottom, left, right);
            }
            Component.BGPainter b = new Component.BGPainter(this, p);
            b.setIgnorCoordinates(true);
            this.getStyle().setBgPainter(b);
            b.setPreviousForm(this.previousForm);
        }
        if (modal) {
            this.initFocused();
            if (this.getTransitionOutAnimator() == null && this.getTransitionInAnimator() == null) {
                this.initLaf(UIManager.getInstance().getLookAndFeel());
            }
            this.initComponentImpl();
            Display.getInstance().setCurrent(this);
            this.onShow();
            Display.getInstance().invokeAndBlock(new RunnableWrapper(this, p));
        } else {
            this.initFocused();
            if (this.getTransitionOutAnimator() == null && this.getTransitionInAnimator() == null) {
                this.initLaf(UIManager.getInstance().getLookAndFeel());
            }
            this.initComponentImpl();
            Display.getInstance().setCurrent(this);
            this.onShow();
        }
    }

    void showModal() {
        this.showDialog(true);
    }

    void showDialog(boolean modal) {
        int h = Display.getInstance().getDisplayHeight() - this.menuBar.getPreferredH() - this.title.getPreferredH();
        int w = Display.getInstance().getDisplayWidth();
        int topSpace = h / 100 * 20;
        int bottomSpace = h / 100 * 10;
        int sideSpace = w / 100 * 20;
        this.showModal(topSpace, bottomSpace, sideSpace, sideSpace, true, modal);
    }

    void dispose() {
        this.disposeImpl();
    }

    void disposeImpl() {
        if (this.previousForm != null) {
            this.previousForm.tint = false;
            if (this.previousForm instanceof Dialog) {
                if (!((Dialog)this.previousForm).isDisposed()) {
                    Display.getInstance().setCurrent(this.previousForm);
                }
            } else {
                Display.getInstance().setCurrent(this.previousForm);
            }
            this.previousForm = null;
        }
    }

    void repaint(Component cmp) {
        if (this.isVisible()) {
            if (this.current != null) {
                for (Component c = cmp; c != null; c = c.getParent()) {
                    if (c != this.current.getContents()) continue;
                    Display.getInstance().repaint(cmp);
                    return;
                }
            } else {
                Display.getInstance().repaint(cmp);
            }
        }
    }

    public final Form getComponentForm() {
        return this;
    }

    void hideMenu() {
        super.removeComponent(this.menuBar);
    }

    void restoreMenu() {
        if (this.menuBar.getParent() == null) {
            super.addComponent("South", (Component)this.menuBar);
        }
    }

    public void setFocused(Component focused) {
        if (this.focused == focused && focused != null) {
            this.focused.repaint();
            return;
        }
        Component oldFocus = this.focused;
        this.focused = focused;
        if (oldFocus != null) {
            oldFocus.setFocus(false);
            oldFocus.fireFocusLost();
            this.fireFocusLost(oldFocus);
            if (oldFocus.getParent() != null) {
                oldFocus.repaint();
            }
        }
        if (focused != null && this.focused == focused) {
            focused.setFocus(true);
            focused.fireFocusGained();
            this.fireFocusGained(focused);
            focused.repaint();
        }
    }

    public Component getFocused() {
        return this.focused;
    }

    protected void longKeyPress(int keyCode) {
        if (this.focused != null && this.focused.getComponentForm() == this) {
            this.focused.longKeyPress(keyCode);
        }
    }

    public void keyPressed(int keyCode) {
        int game = Display.getInstance().getGameAction(keyCode);
        if (keyCode == leftSK || keyCode == rightSK || keyCode == rightSK2 || keyCode == backSK || keyCode == clearSK || keyCode == backspaceSK || Display.getInstance().isThirdSoftButton() && game == 8) {
            this.menuBar.keyPressed(keyCode);
            return;
        }
        if (this.focused != null) {
            this.focused.keyPressed(keyCode);
            if (this.focused.handlesInput()) {
                return;
            }
            if (this.focused.getComponentForm() == this) {
                if (this.focused != null && this.focused.handlesInput()) {
                    return;
                }
                this.updateFocus(Display.getInstance().getGameAction(keyCode));
            } else {
                this.initFocused();
            }
        } else {
            this.initFocused();
        }
    }

    public Layout getLayout() {
        return this.contentPane.getLayout();
    }

    public void keyReleased(int keyCode) {
        Command defaultCmd;
        int game = Display.getInstance().getGameAction(keyCode);
        if (keyCode == leftSK || keyCode == rightSK || keyCode == rightSK2 || keyCode == backSK || keyCode == clearSK || keyCode == backspaceSK || Display.getInstance().isThirdSoftButton() && game == 8) {
            this.menuBar.keyReleased(keyCode);
            return;
        }
        if (this.focused != null && this.focused.getComponentForm() == this) {
            this.focused.keyReleased(keyCode);
        }
        if (game == 8 && this.current == null && (defaultCmd = this.getDefaultCommand()) != null) {
            defaultCmd.actionPerformed(new ActionEvent(defaultCmd, keyCode));
            this.actionCommandImpl(defaultCmd);
        }
        this.fireKeyEvent(this.keyListeners, keyCode);
        this.fireKeyEvent(this.gameKeyListeners, game);
    }

    private void fireKeyEvent(Hashtable keyListeners, int keyCode) {
        Vector listeners;
        if (keyListeners != null && (listeners = (Vector)keyListeners.get(new Integer(keyCode))) != null) {
            ActionEvent evt = new ActionEvent(this, keyCode);
            for (int iter = 0; iter < listeners.size(); ++iter) {
                ((ActionListener)listeners.elementAt(iter)).actionPerformed(evt);
                if (!evt.isConsumed()) continue;
                return;
            }
        }
    }

    public void keyRepeated(int keyCode) {
        if (this.focused != null) {
            this.focused.keyRepeated(keyCode);
            if (!this.focused.handlesInput()) {
                this.keyPressed(keyCode);
                this.keyReleased(keyCode);
            }
        } else {
            this.keyPressed(keyCode);
            this.keyReleased(keyCode);
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.focusCycleRoot.equals(this.contentPane) && this.menuBar.contains(x, y)) {
            Component cmp = this.menuBar.getComponentAt(x, y);
            if (cmp != null) {
                cmp.pointerPressed(x, y);
            }
            return;
        }
        if (!this.focusCycleRoot.equals(this.contentPane) && !this.focusCycleRoot.contains(x, y)) {
            if (this.current != null) {
                this.current.setVisible(false);
            }
            return;
        }
        if (this.focusCycleRoot instanceof Container) {
            Component cmp = ((Container)this.focusCycleRoot).getComponentAt(x, y);
            if (cmp != null && cmp.isFocusable()) {
                this.setFocused(cmp);
                cmp.pointerPressed(x, y);
                cmp.repaint();
            }
        } else {
            this.focusCycleRoot.pointerPressed(x, y);
            this.focusCycleRoot.repaint();
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.dragged != null) {
            this.dragged.pointerDragged(x, y);
            return;
        }
        if (this.focusCycleRoot instanceof Container) {
            Component cmp = ((Container)this.focusCycleRoot).getComponentAt(x, y);
            if (cmp != null) {
                if (cmp.isFocusable()) {
                    this.setFocused(cmp);
                }
                cmp.pointerDragged(x, y);
                cmp.repaint();
            }
        } else {
            this.focusCycleRoot.pointerDragged(x, y);
            this.focusCycleRoot.repaint();
        }
    }

    public void pointerHover(int[] x, int[] y) {
        if (this.focusCycleRoot instanceof Container) {
            Component cmp = ((Container)this.focusCycleRoot).getComponentAt(x[0], y[0]);
            if (cmp != null) {
                if (cmp.isFocusable()) {
                    this.setFocused(cmp);
                }
                cmp.pointerHover(x, y);
                cmp.repaint();
            }
        } else {
            this.focusCycleRoot.pointerHover(x, y);
            this.focusCycleRoot.repaint();
        }
    }

    public boolean isSingleFocusMode() {
        this.initFocusDown();
        return this.focusDownSequence.size() == 1;
    }

    public void pointerReleased(int x, int y) {
        if (this.dragged == null) {
            if (this.focusCycleRoot.equals(this.contentPane) && this.menuBar.contains(x, y)) {
                Component cmp = this.menuBar.getComponentAt(x, y);
                if (cmp != null) {
                    cmp.pointerReleased(x, y);
                }
                return;
            }
            if (!this.focusCycleRoot.equals(this.contentPane) && !this.focusCycleRoot.contains(x, y)) {
                if (this.current != null) {
                    this.current.setVisible(false);
                }
                this.focusCycleRoot = this.contentPane;
                if (this.lastFocused != null) {
                    this.setFocused(this.lastFocused);
                } else {
                    this.initFocused();
                }
                return;
            }
            Component cmp = null;
            if (this.focusCycleRoot instanceof Container) {
                cmp = ((Container)this.focusCycleRoot).getComponentAt(x, y);
                if (cmp != null && cmp.isFocusable()) {
                    this.setFocused(cmp);
                }
            } else {
                cmp = this.focusCycleRoot;
            }
            if (cmp != null) {
                cmp.pointerReleased(x, y);
                cmp.repaint();
            }
        } else {
            this.dragged.pointerReleased(x, y);
            this.dragged = null;
        }
    }

    public void setScrollableY(boolean scrollableY) {
        this.getContentPane().setScrollableY(scrollableY);
    }

    public void setScrollableX(boolean scrollableX) {
        this.getContentPane().setScrollableX(scrollableX);
    }

    public void addCommand(Command cmd, int offset) {
        this.menuBar.addCommand(cmd, offset);
    }

    public int getCommandCount() {
        return this.menuBar.getCommandCount();
    }

    public Command getCommand(int index) {
        return this.menuBar.getCommand(index);
    }

    public void addCommand(Command cmd) {
        this.menuBar.addCommand(cmd);
    }

    public void removeCommand(Command cmd) {
        this.menuBar.removeCommand(cmd);
    }

    public void setCyclicFocus(boolean cyclicFocus) {
        this.cyclicFocus = cyclicFocus;
    }

    public boolean isCyclicFocus() {
        return this.cyclicFocus;
    }

    private void updateFocus(int gameAction) {
        Component focused = this.getFocused();
        switch (gameAction) {
            case 6: {
                if (focused.getNextFocusDown() != null && focused.getNextFocusDown().getComponentForm() == this) {
                    focused = focused.getNextFocusDown();
                    break;
                }
                this.initFocusDown();
                int i = this.focusDownSequence.indexOf(focused) + 1;
                if (this.focusDownSequence.size() <= 0) break;
                if (i == this.focusDownSequence.size()) {
                    i = this.cyclicFocus ? 0 : this.focusDownSequence.size() - 1;
                }
                focused = (Component)this.focusDownSequence.elementAt(i);
                break;
            }
            case 1: {
                if (focused.getNextFocusUp() != null && focused.getNextFocusUp().getComponentForm() == this) {
                    focused = focused.getNextFocusUp();
                    break;
                }
                this.initFocusDown();
                if (this.focusDownSequence.size() <= 0) break;
                int i = this.focusDownSequence.indexOf(focused) - 1;
                if (i < 0) {
                    i = this.cyclicFocus ? this.focusDownSequence.size() - 1 : 0;
                }
                focused = (Component)this.focusDownSequence.elementAt(i);
                break;
            }
            case 5: {
                if (focused.getNextFocusRight() != null && focused.getNextFocusRight().getComponentForm() == this) {
                    focused = focused.getNextFocusRight();
                    break;
                }
                this.initFocusRight();
                if (this.focusRightSequence.size() <= 0) break;
                int i = this.focusRightSequence.indexOf(focused) + 1;
                if (i == this.focusRightSequence.size()) {
                    i = this.cyclicFocus ? 0 : this.focusRightSequence.size() - 1;
                }
                focused = (Component)this.focusRightSequence.elementAt(i);
                break;
            }
            case 2: {
                if (focused.getNextFocusLeft() != null && focused.getNextFocusLeft().getComponentForm() == this) {
                    focused = focused.getNextFocusLeft();
                    break;
                }
                this.initFocusRight();
                if (this.focusRightSequence.size() <= 0) break;
                int i = this.focusRightSequence.indexOf(focused) - 1;
                if (i < 0) {
                    i = this.cyclicFocus ? this.focusRightSequence.size() - 1 : 0;
                }
                focused = (Component)this.focusRightSequence.elementAt(i);
                break;
            }
            default: {
                return;
            }
        }
        this.setFocused(focused);
        if (focused != null) {
            this.scrollComponentToVisible(focused);
        }
    }

    public void scrollComponentToVisible(Component c) {
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isScrollable()) continue;
            parent.scrollComponentToVisible(c);
            return;
        }
    }

    public void setMenuCellRenderer(ListCellRenderer menuCellRenderer) {
        this.menuBar.setMenuCellRenderer(menuCellRenderer);
    }

    public void removeAllCommands() {
        this.menuBar.removeAllCommands();
    }

    void requestFocus(Component cmp) {
        if (cmp.isFocusable() && this.contains(cmp)) {
            this.scrollComponentToVisible(cmp);
            this.setFocused(cmp);
        }
    }

    public void paint(Graphics g) {
        super.paintBackground(g);
        super.paint(g);
        if (this.tint) {
            g.setColor(this.tintColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight(), (byte)(this.tintColor >> 24 & 0xFF));
        }
    }

    public void setScrollable(boolean scrollable) {
        this.contentPane.setScrollable(scrollable);
    }

    void showPopup(Popup pop) {
        if (this.current == null || !this.current.equals(pop)) {
            this.current = pop;
            if (this.contains(this.focused)) {
                this.lastFocused = this.focused;
            }
            this.focusCycleRoot = pop.getContents();
            if (this.focusCycleRoot.isFocusable()) {
                this.setFocused(this.focusCycleRoot);
            } else {
                this.setFocused(((Container)this.focusCycleRoot).getComponentAt(0));
            }
        }
        this.focusCycleRoot.repaint();
    }

    void hidePopups() {
        if (this.current != null) {
            this.current = null;
            this.focusCycleRoot = this.contentPane;
            this.setFocused(this.lastFocused);
            this.repaint();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.mediaComponents != null) {
            int size = this.mediaComponents.size();
            for (int i = 0; i < size; ++i) {
                Component mediaCmp = (Component)this.mediaComponents.elementAt(i);
                mediaCmp.setVisible(visible);
            }
        }
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public void setTintColor(int tintColor) {
        this.tintColor = tintColor;
    }

    void addSelectCommand() {
        if (Display.getInstance().isThirdSoftButton()) {
            if (this.selectCommand == null) {
                this.selectCommand = new Command(UIManager.getInstance().localize("select", "Select"));
            }
            this.addCommand(this.selectCommand);
        }
    }

    void removeSelectCommand() {
        if (Display.getInstance().isThirdSoftButton()) {
            this.removeCommand(this.selectCommand);
        }
    }

    public void setMenuTransitions(Transition transitionIn, Transition transitionOut) {
        this.menuBar.setTransitions(transitionIn, transitionOut);
    }

    protected String paramString() {
        return super.paramString() + ", title = " + this.title + ", visible = " + this.isVisible();
    }

    protected Command showMenuDialog(Dialog menu) {
        int marginLeft = (int)((float)this.getWidth() * 0.25f);
        int marginRight = 0;
        if (this.isReverseSoftButtons()) {
            marginRight = marginLeft;
            marginLeft = 0;
        }
        int height = this.getHeight() / 2;
        return menu.show(height, 0, marginLeft, marginRight, true);
    }

    protected boolean isReverseSoftButtons() {
        return UIManager.getInstance().getLookAndFeel().isReverseSoftButtons();
    }

    protected List createCommandList(Vector commands) {
        List l = new List(commands);
        l.setStyle(UIManager.getInstance().getComponentStyle("CommandList"));
        ((Component)((Object)l.getRenderer())).setStyle(UIManager.getInstance().getComponentStyle("Command"));
        l.setFixedSelection(1);
        return l;
    }

    class MenuBar
    extends Container
    implements ActionListener {
        private Command menuCommand;
        private Vector commands = new Vector();
        private Button[] soft;
        private Command[] softCommand;
        private Button left;
        private Button right;
        private Button main;
        private ListCellRenderer menuCellRenderer;
        private Transition transitionIn;
        private Transition transitionOut;
        private List commandList;
        private Command selectMenuItem;
        private Command cancelMenuItem;
        private Style menuStyle;

        public MenuBar() {
            LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
            this.menuStyle = UIManager.getInstance().getComponentStyle("Menu");
            this.menuCommand = new Command(UIManager.getInstance().localize("menu", "Menu"), lf.getMenuIcons()[2]);
            if (lf.getDefaultMenuTransitionIn() != null || lf.getDefaultMenuTransitionOut() != null) {
                this.transitionIn = lf.getDefaultMenuTransitionIn();
                this.transitionOut = lf.getDefaultMenuTransitionOut();
            } else {
                this.transitionIn = CommonTransitions.createSlide(1, true, 300, true);
                this.transitionOut = CommonTransitions.createSlide(1, false, 300, true);
            }
            this.menuCellRenderer = lf.getMenuRenderer();
            if (Display.getInstance().getImplementation().getSoftkeyCount() > 1) {
                if (Display.getInstance().isThirdSoftButton()) {
                    this.setLayout(new GridLayout(1, 3));
                    this.soft = new Button[]{this.createSoftButton(), this.createSoftButton(), this.createSoftButton()};
                    this.main = this.soft[0];
                    this.main.setAlignment(4);
                    this.left = this.soft[1];
                    this.right = this.soft[2];
                    this.addComponent(this.left);
                    this.addComponent(this.main);
                    this.addComponent(this.right);
                    if (Form.this.isReverseSoftButtons()) {
                        Button b = this.soft[1];
                        this.soft[1] = this.soft[2];
                        this.soft[2] = b;
                    }
                } else {
                    this.setLayout(new GridLayout(1, 2));
                    this.soft = new Button[]{this.createSoftButton(), this.createSoftButton()};
                    this.main = this.soft[0];
                    this.left = this.soft[0];
                    this.right = this.soft[1];
                    this.addComponent(this.left);
                    this.addComponent(this.right);
                    if (Form.this.isReverseSoftButtons()) {
                        Button b = this.soft[0];
                        this.soft[0] = this.soft[1];
                        this.soft[1] = b;
                    }
                }
            } else {
                this.soft = new Button[]{this.createSoftButton()};
            }
            if (this.left != null) {
                this.left.setAlignment(1);
                this.right.setAlignment(3);
            }
            this.softCommand = new Command[this.soft.length];
        }

        private void updateCommands() {
            if (this.soft.length > 1) {
                this.soft[0].setText("");
                this.soft[1].setText("");
                this.soft[0].setIcon(null);
                this.soft[1].setIcon(null);
                int commandSize = this.commands.size();
                if (this.soft.length > 2) {
                    this.soft[2].setText("");
                    if (commandSize > 2) {
                        this.softCommand[2] = commandSize > 3 ? this.menuCommand : (Command)this.commands.elementAt(this.commands.size() - 3);
                        this.soft[2].setText(this.softCommand[2].getCommandName());
                        this.soft[2].setIcon(this.softCommand[2].getIcon());
                    } else {
                        this.softCommand[2] = null;
                    }
                }
                if (commandSize > 0) {
                    this.softCommand[0] = (Command)this.commands.elementAt(this.commands.size() - 1);
                    this.soft[0].setText(this.softCommand[0].getCommandName());
                    this.soft[0].setIcon(this.softCommand[0].getIcon());
                    if (commandSize > 1) {
                        this.softCommand[1] = this.soft.length == 2 && commandSize > 2 ? this.menuCommand : (Command)this.commands.elementAt(this.commands.size() - 2);
                        this.soft[1].setText(this.softCommand[1].getCommandName());
                        this.soft[1].setIcon(this.softCommand[1].getIcon());
                    } else {
                        this.softCommand[1] = null;
                    }
                } else {
                    this.softCommand[0] = null;
                    this.softCommand[1] = null;
                }
                if (commandSize == 1 && Form.this.isVisible()) {
                    Form.this.revalidate();
                }
                this.repaint();
            }
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            Object src = evt.getSource();
            if (this.commandList == null) {
                Button source = (Button)src;
                for (int iter = 0; iter < this.soft.length; ++iter) {
                    if (source != this.soft[iter]) continue;
                    if (this.softCommand[iter] == this.menuCommand) {
                        this.showMenu();
                        return;
                    }
                    if (this.softCommand[iter] != null) {
                        ActionEvent e = new ActionEvent(this.softCommand[iter]);
                        this.softCommand[iter].actionPerformed(e);
                        if (!e.isConsumed()) {
                            Form.this.actionCommandImpl(this.softCommand[iter]);
                        }
                    }
                    return;
                }
            } else {
                Container parent;
                List l = this.commandList;
                if (src instanceof Button) {
                    for (int iter = 0; iter < this.soft.length; ++iter) {
                        if (src != this.soft[iter]) continue;
                        for (parent = l.getParent(); parent != null; parent = parent.getParent()) {
                            if (!(parent instanceof Dialog)) continue;
                            ((Dialog)parent).actionCommand(this.softCommand[iter]);
                            return;
                        }
                    }
                }
                Command c = (Command)l.getSelectedItem();
                for (parent = l.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Dialog)) continue;
                    ((Dialog)parent).actionCommand(c);
                    return;
                }
            }
        }

        private Button createSoftButton() {
            Button b = new Button();
            b.addActionListener(this);
            b.setFocusPainted(false);
            b.setFocusable(false);
            b.setBorderPainted(false);
            this.updateSoftButtonStyle(b);
            return b;
        }

        private void updateSoftButtonStyle(Button b) {
            Style s = new Style(this.getStyle());
            b.setStyle(s);
            s.setBgImage(null);
            s.setBorder(null);
            s.setMargin(2, 2, 2, 2);
            s.setPadding(2, 2, 2, 2);
            s.setBgTransparency(0);
        }

        public void setStyle(Style style) {
            super.setStyle(style);
            for (int i = 0; i < this.soft.length; ++i) {
                this.updateSoftButtonStyle(this.soft[i]);
            }
        }

        protected Dimension calcPreferredSize() {
            if (this.soft.length > 1) {
                Dimension d = super.calcPreferredSize();
                if ((this.soft[0].getText() == null || this.soft[0].getText().equals("")) && (this.soft[1].getText() == null || this.soft[1].getText().equals(""))) {
                    d.setHeight(0);
                }
                return d;
            }
            return super.calcPreferredSize();
        }

        public void setTransitions(Transition transitionIn, Transition transitionOut) {
            this.transitionIn = transitionIn;
            this.transitionOut = transitionOut;
        }

        private void showMenu() {
            Dialog d = new Dialog();
            d.setDialogStyle(this.menuStyle);
            d.setMenu(true);
            this.menuStyle.removeStyleListener(d.getContentPane());
            d.setTransitionInAnimator(this.transitionIn);
            d.setTransitionOutAnimator(this.transitionOut);
            d.setLayout(new BorderLayout());
            d.setScrollable(false);
            ((Form)d).menuBar.commandList = Form.this.createCommandList(this.commands);
            if (this.menuCellRenderer != null) {
                ((Form)d).menuBar.commandList.setListCellRenderer(this.menuCellRenderer);
            }
            d.getContentPane().getStyle().setPadding(0, 0, 0, 0);
            d.addComponent("Center", (Component)((Form)d).menuBar.commandList);
            LookAndFeel lf = UIManager.getInstance().getLookAndFeel();
            this.selectMenuItem = new Command(UIManager.getInstance().localize("select", "Select"), lf.getMenuIcons()[0]);
            this.cancelMenuItem = new Command(UIManager.getInstance().localize("cancel", "Cancel"), lf.getMenuIcons()[1]);
            if (Display.getInstance().isThirdSoftButton()) {
                d.addCommand(this.selectMenuItem);
                d.addCommand(this.cancelMenuItem);
            } else {
                d.addCommand(this.cancelMenuItem);
                d.addCommand(this.selectMenuItem);
            }
            d.setClearCommand(this.cancelMenuItem);
            d.setBackCommand(this.cancelMenuItem);
            ((Form)d).menuBar.commandList.addActionListener(((Form)d).menuBar);
            Command result = Form.this.showMenuDialog(d);
            if (result != this.cancelMenuItem) {
                Command c = null;
                c = result == this.selectMenuItem ? (Command)((Form)d).menuBar.commandList.getSelectedItem() : result;
                ActionEvent e = new ActionEvent(c);
                c.actionPerformed(e);
                Form.this.actionCommandImpl(c);
            }
            ((Form)d).menuBar.commandList.removeActionListener(((Form)d).menuBar);
            Form upcoming = Display.getInstance().getCurrentUpcoming();
            if (upcoming == Form.this) {
                d.disposeImpl();
            } else {
                Form.this.tint = upcoming instanceof Dialog;
            }
        }

        public Button[] getSoftButtons() {
            return this.soft;
        }

        protected String getUIID() {
            return "SoftButton";
        }

        public void addCommand(Command cmd) {
            if (this.commands.contains(cmd)) {
                return;
            }
            if (this.soft.length > 2 && cmd == Form.this.getDefaultCommand()) {
                this.commands.addElement(cmd);
            } else {
                this.commands.insertElementAt(cmd, 0);
            }
            this.updateCommands();
        }

        public Command getCommand(int index) {
            return (Command)this.commands.elementAt(index);
        }

        public int getCommandCount() {
            return this.commands.size();
        }

        public void addCommand(Command cmd, int index) {
            if (this.commands.contains(cmd)) {
                return;
            }
            this.commands.insertElementAt(cmd, index);
            this.updateCommands();
        }

        public void removeAllCommands() {
            this.commands.removeAllElements();
            this.updateCommands();
        }

        public void removeCommand(Command cmd) {
            this.commands.removeElement(cmd);
            this.updateCommands();
        }

        public void setMenuCellRenderer(ListCellRenderer menuCellRenderer) {
            this.menuCellRenderer = menuCellRenderer;
        }

        public Style getMenuStyle() {
            return this.menuStyle;
        }

        public void keyPressed(int keyCode) {
            if (this.commands.size() > 0) {
                if (keyCode == leftSK) {
                    if (this.left != null) {
                        this.left.pressed();
                    }
                } else if (keyCode == rightSK || keyCode == rightSK2) {
                    if (this.right != null) {
                        this.right.pressed();
                    }
                } else if (Display.getInstance().getGameAction(keyCode) == 8) {
                    this.main.pressed();
                }
            }
        }

        public void keyReleased(int keyCode) {
            if (this.soft.length < 2 && keyCode == leftSK) {
                this.showMenu();
                return;
            }
            if (this.commands.size() > 0) {
                if (keyCode == leftSK) {
                    if (this.left != null) {
                        this.left.released();
                    }
                    return;
                }
                if (keyCode == rightSK || keyCode == rightSK2) {
                    if (this.right != null) {
                        this.right.released();
                    }
                    return;
                }
                if (Display.getInstance().getGameAction(keyCode) == 8) {
                    this.main.released();
                    return;
                }
            }
            Command c = null;
            if (keyCode == backSK) {
                c = Form.this.getBackCommand();
            } else if (keyCode == clearSK || keyCode == backspaceSK) {
                c = Form.this.getClearCommand();
            }
            if (c != null) {
                c.actionPerformed(new ActionEvent(c, keyCode));
                Form.this.actionCommandImpl(c);
            }
        }

        public void refreshTheme() {
            super.refreshTheme();
            if (this.menuStyle.isModified()) {
                this.menuStyle.merge(UIManager.getInstance().getComponentStyle("Menu"));
            } else {
                this.menuStyle = UIManager.getInstance().getComponentStyle("Menu");
            }
            if (this.menuCellRenderer != null) {
                List tmp = new List();
                tmp.setListCellRenderer(this.menuCellRenderer);
                tmp.refreshTheme();
            }
            for (int iter = 0; iter < this.soft.length; ++iter) {
                this.soft[iter].getStyle().merge(this.getStyle());
            }
            this.revalidate();
        }
    }
}

