/*
 * Decompiled with CFR 0.152.
 */
package baby.media;

import baby.GuiMidlet;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.MediaComponent;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BorderLayout;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;
import util.Contents;

class PlayerManager
implements Runnable,
ActionListener,
PlayerListener {
    Form form;
    Player player;
    String locator;
    GuiMidlet midlet;
    boolean is_image;

    public PlayerManager(String _locator, GuiMidlet _midlet, boolean isImage) {
        this.locator = _locator;
        this.midlet = _midlet;
        this.is_image = isImage;
        this.form = new Form("Player Manager");
        this.form.setLayout(new BorderLayout());
        this.form.setCommandListener(this);
        if (this.is_image) {
            this.form.addCommand(Contents.back);
        }
    }

    public void run() {
        try {
            StreamConnection fconn = (StreamConnection)Connector.open((String)this.locator);
            InputStream is = fconn.openInputStream();
            String type = "";
            if (this.is_image) {
                try {
                    this.form.addComponent("Center", (Component)new Label(Contents.displayImage(is)));
                    this.form.show();
                }
                catch (NullPointerException e) {
                    this.form.removeAll();
                }
            } else {
                int count = 1;
                boolean markable = true;
                if (this.locator.endsWith("wav")) {
                    type = "audio/x-wav";
                    markable = false;
                } else if (this.locator.endsWith("mp3")) {
                    type = "audio/mpeg";
                } else if (this.locator.endsWith("mid")) {
                    type = "audio/mid";
                } else if (this.locator.endsWith("mpg") || this.locator.endsWith("mpeg")) {
                    type = "video/mpeg";
                    count = -1;
                }
                this.player = Manager.createPlayer((InputStream)is, (String)type);
                this.player.addPlayerListener((PlayerListener)this);
                this.player.setLoopCount(count);
                this.player.prefetch();
                this.player.realize();
                MediaComponent media = new MediaComponent(this.player);
                this.form.addComponent("Center", (Component)media);
                this.form.show();
                this.player.start();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            this.form.removeAll();
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event.equals("started") && new Long(0L).equals((Long)eventData)) {
            VideoControl vc = null;
            vc = (VideoControl)player.getControl("VideoControl");
            if (vc != null) {
                try {
                    vc.initDisplayMode(0, null);
                    vc.setDisplayLocation(0, 0);
                    vc.setDisplayFullScreen(true);
                    vc.setVisible(true);
                }
                catch (MediaException e) {
                    // empty catch block
                }
            }
            this.form.show();
        } else if (event.equals("closed")) {
            this.form.removeAll();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        Command command = arg0.getCommand();
        try {
            if (command == Contents.back) {
                this.form.removeAll();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            this.form.removeAll();
        }
    }
}

