/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;

public class LayoutStyle {
    public static final int RELATED = 0;
    public static final int UNRELATED = 1;
    public static final int INDENT = 3;
    private static LayoutStyle layoutStyle = new LayoutStyle();

    public static void setSharedInstance(LayoutStyle layout) {
        layoutStyle = layout;
    }

    public static LayoutStyle getSharedInstance() {
        return layoutStyle;
    }

    public int getPreferredGap(Component component1, Component component2, int type, int position, Container parent) {
        if (position != 1 && position != 5 && position != 7 && position != 3) {
            throw new IllegalArgumentException("Invalid position");
        }
        if (component1 == null || component2 == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        if (type == 0) {
            return 6;
        }
        if (type == 1) {
            return 12;
        }
        if (type == 3) {
            if (position == 3 || position == 7) {
                int gap = this.getButtonChildIndent(component1, position);
                if (gap != 0) {
                    return gap;
                }
                return 6;
            }
            return 6;
        }
        throw new IllegalArgumentException("Invalid type");
    }

    public int getContainerGap(Component component, int position, Container parent) {
        if (position != 1 && position != 5 && position != 7 && position != 3) {
            throw new IllegalArgumentException("Invalid position");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must be non-null");
        }
        return 12;
    }

    int getCBRBPadding(Component source, Component target, int position, int offset) {
        if ((offset -= this.getCBRBPadding(source, position)) > 0) {
            offset -= this.getCBRBPadding(target, this.flipDirection(position));
        }
        if (offset < 0) {
            return 0;
        }
        return offset;
    }

    int getCBRBPadding(Component source, int position, int offset) {
        return Math.max(offset -= this.getCBRBPadding(source, position), 0);
    }

    int flipDirection(int position) {
        switch (position) {
            case 1: {
                return 5;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Illegal position: " + position);
    }

    private int getCBRBPadding(Component c, int position) {
        return 0;
    }

    private int getInset(Component c, int position) {
        int insetLeft = c.getStyle().getMargin(1);
        int insetTop = c.getStyle().getMargin(0);
        int insetRight = c.getStyle().getMargin(3);
        int insetBottom = c.getStyle().getMargin(2);
        switch (position) {
            case 1: {
                return insetTop;
            }
            case 5: {
                return insetBottom;
            }
            case 3: {
                return insetRight;
            }
            case 7: {
                return insetLeft;
            }
        }
        throw new IllegalArgumentException("Illegal argument position: " + position);
    }

    int getButtonChildIndent(Component c, int position) {
        return 0;
    }
}

