/*
 * Decompiled with CFR 0.152.
 */
package baby;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.Style;

public class Progress
extends Component {
    private byte percent;
    private Image unfilled;
    private Image filled;

    public Progress() {
        this.setFocusable(false);
    }

    public Progress(Image unfilled, Image filled) {
        this();
        this.unfilled = unfilled;
        this.filled = filled;
    }

    public String getUIID() {
        return "Progress";
    }

    public byte getProgress() {
        return this.percent;
    }

    public void setProgress(byte percent) {
        this.percent = percent;
        this.repaint();
    }

    protected Dimension calcPreferredSize() {
        if (this.filled != null) {
            return new Dimension(this.filled.getWidth(), this.filled.getHeight());
        }
        return new Dimension(Display.getInstance().getDisplayWidth(), Font.getDefaultFont().getHeight());
    }

    public void paint(Graphics g) {
        int width = (int)((float)this.percent / 100.0f * (float)this.getWidth());
        if (this.filled != null) {
            if (this.filled.getWidth() != this.getWidth()) {
                this.filled = this.filled.scaled(this.getWidth(), this.getHeight());
                this.unfilled = this.unfilled.scaled(this.getWidth(), this.getHeight());
            }
            g.drawImage(this.unfilled, this.getX(), this.getY());
            g.clipRect(this.getX(), this.getY(), width, this.getHeight());
            g.drawImage(this.filled, this.getX(), this.getY());
        } else {
            Style s = this.getStyle();
            g.setColor(s.getBgColor());
            int curve = this.getHeight() / 2 - 1;
            g.fillRoundRect(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1, curve, curve);
            g.setColor(s.getFgColor());
            g.drawRoundRect(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1, curve, curve);
            g.clipRect(this.getX(), this.getY(), width - 1, this.getHeight() - 1);
            g.setColor(s.getBgSelectionColor());
            g.fillRoundRect(this.getX(), this.getY(), this.getWidth() - 1, this.getHeight() - 1, curve, curve);
        }
    }
}

